/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.trans.XPathException;
import org.apache.tools.ant.types.XMLCatalog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLCatalogAdapter
implements ResourceResolver,
URIResolver {
    private final XMLCatalog catalog;

    public XMLCatalogAdapter(XMLCatalog catalog) {
        this.catalog = catalog;
    }

    public Source resolve(ResourceRequest request) throws XPathException {
        try {
            if (request.publicId != null) {
                InputSource inputSource = this.catalog.resolveEntity(request.publicId, request.uri);
                if (inputSource.getByteStream() != null) {
                    return new StreamSource(inputSource.getByteStream(), inputSource.getSystemId());
                }
                if (inputSource.getCharacterStream() != null) {
                    return new StreamSource(inputSource.getCharacterStream(), inputSource.getSystemId());
                }
                return new StreamSource(inputSource.getSystemId());
            }
            return this.catalog.resolve(request.relativeUri, request.baseUri);
        }
        catch (IOException | TransformerException | SAXException e) {
            throw new XPathException((Throwable)e);
        }
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        return this.catalog.resolve(href, base);
    }
}

