/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AbbreviationNodeRenderer
implements NodeRenderer {
    private final AbbreviationOptions options;

    public AbbreviationNodeRenderer(DataHolder options) {
        this.options = new AbbreviationOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(Abbreviation.class, this::render), new NodeRenderingHandler(AbbreviationBlock.class, this::render)));
    }

    private void render(AbbreviationBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(Abbreviation node, NodeRendererContext context, HtmlWriter html) {
        String tag;
        String text = node.getChars().unescape();
        BasedSequence abbreviation = node.getAbbreviation();
        if (this.options.useLinks) {
            html.attr((CharSequence)"href", (CharSequence)"#");
            tag = "a";
        } else {
            tag = "abbr";
        }
        html.attr((CharSequence)"title", (CharSequence)abbreviation);
        html.srcPos(node.getChars()).withAttr().tag((CharSequence)tag);
        html.text((CharSequence)text);
        html.closeTag((CharSequence)tag);
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new AbbreviationNodeRenderer(options);
        }
    }
}

